/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.schedops;

import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.HMC;
import com.ibm.hwmca.fw.managed.ManagedObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.schedops.DisplayDataImpl;
import com.ibm.hwmca.fw.schedops.DisplayDataNewImpl;
import com.ibm.hwmca.fw.schedops.DisplayFilter;
import com.ibm.hwmca.fw.schedops.OperationParametersTasklet;
import com.ibm.hwmca.fw.schedops.OperationTarget;
import com.ibm.hwmca.fw.schedops.SchedOpsMessage;
import com.ibm.hwmca.fw.schedops.Schedulable;
import com.ibm.hwmca.fw.schedops.SchedulableConfigManager;
import com.ibm.hwmca.fw.schedops.SchedulableDescriptor;
import com.ibm.hwmca.fw.schedops.Schedule;
import com.ibm.hwmca.fw.schedops.ScheduleException;
import com.ibm.hwmca.fw.schedops.ScheduledOperation;
import com.ibm.hwmca.fw.schedops.ScheduledOperationsErrorIDs;
import com.ibm.hwmca.fw.schedops.Scheduler;
import com.ibm.hwmca.fw.schedops.SchedulerException;
import com.ibm.hwmca.fw.schedops.beans.AddSchedOpsBean;
import com.ibm.hwmca.fw.schedops.beans.DateTimeBean;
import com.ibm.hwmca.fw.schedops.beans.DetailsFrameBean;
import com.ibm.hwmca.fw.schedops.beans.RepeatBean;
import com.ibm.hwmca.fw.schedops.beans.SchedOpsBean;
import com.ibm.hwmca.fw.schedops.beans.SchedOpsDetailsBean;
import com.ibm.hwmca.fw.schedops.beans.SetUpSchedOpsBean;
import com.ibm.hwmca.fw.schedops.beans.TimeRangeBean;
import com.ibm.hwmca.fw.target.CommonTargeting;
import com.ibm.hwmca.fw.target.Target;
import com.ibm.hwmca.fw.target.TargetActionListener;
import com.ibm.hwmca.fw.target.TargetRetriever;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptor;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorData;
import com.ibm.hwmca.fw.tasklet.DisplayAreaDescriptorDelegate;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class ScheduledOperationsTasklet
extends PanelTasklet
implements PropertyChangeListener {
    private static final String CLASS_NAME = "[ScheduledOperationsTasklet] ";
    private static final String TRACE_MASKT = "XTIMxxxT";
    private static final String TRACE_MASKF = "XTIMxxxF";
    private static final String TRACE_MASKD = "XTIMxxxD";
    private static final String AUIML_FILE = "com.ibm.hwmca.fw.schedops.res.SchedOpsRes";
    private static final String ADD_SCHEDOP_PANEL = "AddSchedOpsPanel";
    private static final String DATE_TIME_PANEL = "DateTimePanel";
    private static final String REPEAT_PANEL = "RepeatPanel";
    private static final String DETAILS_PANEL = "SchedOpsDetailsPanel";
    private static final String CUSTOMIZE_PANEL = "SchedOpsPanel";
    private static final String SETUP_SCHEDOP_PANEL = "SetUpSchedOpsPanel";
    private static final String SETUP_SCHEDOP_MOUNT = "SetUPTPane";
    private static final String DETAILS_FRAME_PANEL = "DetailsPanel";
    private static final String DETAILS_SCHEDOP_MOUNT = "DetailsTPane";
    private static final String DETAILS_TAB_PANEL = "SchedOpsDetailsTPanel";
    private static final String TIME_RANGE_PANEL = "TimeRangePanel";
    private static final String MSG_B1TC1 = "XTIMB1TC1";
    private static final String MSG_B1TI3 = "XTIMB1TI3";
    private static final String MSG_B1TI4 = "XTIMB1TI4";
    private static final String MSG_B1TN1 = "XTIMB1TN1";
    private static final String MSG_B1TN2 = "XTIMB1TN2";
    private static final String MSG_B1TN3 = "XTIMB1TN3";
    private static final String MSG_B1TN5 = "XTIMB1TN5";
    private static final String MSG_UNKWN = "XTIMUNKWN";
    private static final String BUSY_QRY_TITLE = "XTIM.BUSY.QRY.TITLE";
    private static final String BUSY_QRY_MSG = "XTIM.BUSY.QRY.MSG";
    private static final String BUSY_ADD_TITLE = "XTIM.BUSY.ADD.TITLE";
    private static final String BUSY_ADD_MSG = "XTIM.BUSY.ADD.MSG";
    private static final String BUSY_CAN_TITLE = "XTIM.BUSY.CAN.TITLE";
    private static final String BUSY_CAN_MSG = "XTIM.BUSY.CAN.MSG";
    private static final LocalizableText[] OK_BUTTON = new LocalizableText[]{CommonMsgInterface.OK_BUTTON};
    private static final LocalizableText[] OK_CANCEL_BUTTONS = new LocalizableText[]{CommonMsgInterface.OK_BUTTON, CommonMsgInterface.CANCEL_BUTTON};
    private DisplayFilter filter = new DisplayFilter(7, DisplayFilter.Types.ALL);
    private Date lastRefresh = new Date();
    private HashMap schedops = new HashMap();
    private HashMap schedulables = new HashMap();
    private SchedOpPending pending;
    private boolean isPEDEBUG = false;
    private OperationParametersTasklet.InitData initData;
    private boolean isConsoleTask = false;
    private boolean isZHMC = false;

    public ScheduledOperationsTasklet() {
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] >> ScheduledOperationsTasklet()");
        try {
            byte[] type = SimServer.getSimServer().readSim(5);
            this.isZHMC = type[0] != 4;
            Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    SimServer.XPCX_STATUS = " + type[0] + " : " + this.isZHMC);
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    Exception caught retrieving SimServer.XPCX_STATUS");
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] << ScheduledOperationsTasklet()");
    }

    public OperationParametersTasklet.InitData getInitData() {
        return this.initData;
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] >> service()");
        if (request.isInitialRequest()) {
            this.processInitialRequest(request, response);
        } else {
            String source = (String)request.getData("SOURCE");
            String action = (String)request.getData("ACTION");
            Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    Source = " + source);
            Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    Action = " + action);
            if (source.equals("SchedOpsBean")) {
                if (action.endsWith("NewItem")) {
                    this.displayAddSchedOp(request, response);
                } else if (action.endsWith("DeleteItem")) {
                    ArrayList list = (ArrayList)request.getData("DATA");
                    if (list.size() > 0) {
                        SchedOpsMessage message = new SchedOpsMessage("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", MSG_B1TC1);
                        if (this.popupMessageDialog(message).equals(CommonMsgInterface.OK_BUTTON)) {
                            String results = this.removeScheduledOperations(list);
                            if (results != null) {
                                message = new SchedOpsMessage("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", "XTIMCANERR");
                                this.popupMessageDialog(message, new String[]{results});
                            }
                            this.refreshInventory();
                            HashMap<String, Object> map = new HashMap<String, Object>();
                            map.put("COMMAND", "REFRESH");
                            map.put("INVENTORY", this.createDisplayDataList());
                            map.put("DISPLAY_INFO", this.filter.getDisplayString());
                            response.update(map);
                        } else {
                            response.noAction();
                        }
                    } else {
                        response.noAction();
                    }
                } else if (action.endsWith("RefreshItem")) {
                    this.refreshInventory();
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    map.put("COMMAND", "REFRESH");
                    map.put("INVENTORY", this.createDisplayDataList());
                    map.put("DISPLAY_INFO", this.filter.getDisplayString());
                    response.update(map);
                } else if (action.endsWith("SchedDetailsItem") || action.endsWith("DblClkItem")) {
                    this.displayDetails(request, response);
                } else if (action.endsWith("NewTimeRangeItem")) {
                    this.displayNewTimeRange(request, response);
                } else if (action.endsWith("CANCEL") || action.endsWith("ExitItem")) {
                    this.processTaskShutdown(request, response);
                } else {
                    this.processTaskShutdown(request, response);
                }
            } else if (source.equals("AddSchedOpsBean")) {
                if (action.endsWith("OKButton")) {
                    HashMap map = (HashMap)request.getData("DATA");
                    ObjectId moID = (ObjectId)map.get("OBJECTID");
                    Integer key = (Integer)map.get("UNIQUEID");
                    ManagedObject mo = null;
                    Iterator iterator = this.schedulables.keySet().iterator();
                    while (iterator.hasNext()) {
                        mo = (ManagedObject)iterator.next();
                        if (moID.equals(mo.getObjectId())) break;
                    }
                    this.pending = new SchedOpPending();
                    this.pending.target = (OperationTarget)((Object)mo);
                    HashMap scheds = (HashMap)this.schedulables.get(mo);
                    SchedulableDescriptor descriptor = (SchedulableDescriptor)scheds.get(key);
                    this.pending.schedulable = descriptor.createSchedulable(this.pending.target);
                    Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    " + this.pending.target);
                    Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    " + this.pending.schedulable);
                    this.displayDateTimeRepeat(request, response);
                } else if (action.endsWith("CANCEL")) {
                    this.pending = null;
                    response.dispose();
                } else {
                    response.dispose();
                }
            } else if (source.equals("SetUpSchedOpsBean")) {
                if (action.endsWith("SaveButton")) {
                    if (this.pending.isComplete()) {
                        Object subtasklet = null;
                        List children = this.getChildren();
                        if (children != null && children.size() > 0 && children.get(0) instanceof OperationParametersTasklet) {
                            try {
                                this.pending.parms = ((OperationParametersTasklet)children.get(0)).getOperationParameters();
                            }
                            catch (Exception e) {
                                Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    Exception : " + e.getMessage());
                                this.pending.setComplete(false);
                            }
                        }
                        if (this.pending.isComplete()) {
                            if (this.createScheduledOperations()) {
                                PanelTaskletRequest notify = new PanelTaskletRequest("SchedOpsBean");
                                notify.setData("SOURCE", "SchedOpsBean");
                                notify.setData("ACTION", "Server.RefreshItem");
                                this.postRequest("SchedOpsBean", notify);
                                response.dispose();
                            } else {
                                response.noAction();
                            }
                        } else {
                            this.pending.setComplete(true);
                            response.noAction();
                        }
                    } else {
                        this.pending.setComplete(true);
                        response.noAction();
                    }
                } else if (action.endsWith("CANCEL")) {
                    this.pending = null;
                    response.dispose();
                } else {
                    response.noAction();
                }
            } else if (source.equals("DateTimeBean")) {
                if (action.equals("PANEL_DATA")) {
                    HashMap map = (HashMap)request.getData("DATA");
                    Date date = (Date)map.get("DATE");
                    Date time = (Date)map.get("TIME");
                    Long woo = (Long)map.get("WINDOW");
                    Calendar calendarDate = Calendar.getInstance();
                    Calendar calendarTime = Calendar.getInstance();
                    calendarDate.setTime(date);
                    calendarTime.setTime(time);
                    calendarDate.set(9, calendarTime.get(9));
                    calendarDate.set(10, calendarTime.get(10));
                    calendarDate.set(12, calendarTime.get(12));
                    calendarDate.set(13, calendarTime.get(13));
                    calendarDate.set(14, calendarTime.get(14));
                    Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    Date = " + calendarDate.getTime());
                    this.pending.date = calendarDate.getTime();
                    this.pending.woo = woo;
                } else if (action.equals("DATA_NOT_VALID")) {
                    this.pending.setComplete(false);
                }
                response.noAction();
            } else if (source.equals("RepeatBean")) {
                if (action.equals("PANEL_DATA")) {
                    HashMap map = (HashMap)request.getData("DATA");
                    this.pending.freq = (Long)map.get("INTERVAL");
                    this.pending.reps = (Long)map.get("REPETITIONS");
                    this.pending.days = (ArrayList)map.get("DAYSOFWEEK");
                    Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    Freq = " + this.pending.freq);
                    Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    Reps = " + this.pending.reps);
                    Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    Days = " + this.pending.days);
                } else if (action.equals("DATA_NOT_VALID")) {
                    this.pending.setComplete(false);
                }
                response.noAction();
            } else if (source.equals("TimeRangeBean")) {
                Object[] data = (Object[])request.getData("DATA");
                if (action.endsWith("OKButton")) {
                    int amount = (Integer)data[0];
                    String choice = (String)data[1];
                    if (choice.equals("AllItem")) {
                        this.filter = new DisplayFilter(amount, DisplayFilter.Types.ALL);
                    } else if (choice.equals("DaysItem")) {
                        this.filter = new DisplayFilter(amount, DisplayFilter.Types.DAYS);
                    } else if (choice.equals("WeeksItem")) {
                        this.filter = new DisplayFilter(amount, DisplayFilter.Types.WEEKS);
                    } else if (choice.equals("MonthsItem")) {
                        this.filter = new DisplayFilter(amount, DisplayFilter.Types.MONTHS);
                    }
                    response.dispose();
                    PanelTaskletRequest notify = new PanelTaskletRequest("SchedOpsBean");
                    notify.setData("SOURCE", "SchedOpsBean");
                    notify.setData("ACTION", "Server.RefreshItem");
                    this.postRequest("SchedOpsBean", notify);
                } else if (action.endsWith("ResetButton")) {
                    response.noAction();
                } else if (action.endsWith("CANCEL")) {
                    response.dispose();
                } else {
                    response.dispose();
                }
            } else if (source.equals("SchedOpsDetailsBean")) {
                if (action.endsWith("OKButton")) {
                    response.dispose();
                } else if (action.endsWith("CANCEL")) {
                    response.dispose();
                } else {
                    response.dispose();
                }
            } else if (source.equals("DetailsFrameBean")) {
                if (action.endsWith("OKButton")) {
                    response.dispose();
                } else if (action.endsWith("CANCEL")) {
                    response.dispose();
                } else {
                    response.dispose();
                }
            } else {
                this.processTaskShutdown(request, response);
            }
        }
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] << service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] <> logException()");
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet]    Exception = " + throwable);
        new FrameworkLog(ScheduledOperationsErrorIDs.LOGINFO, 257, new HException(throwable)).log();
    }

    public void propertyChange(PropertyChangeEvent event) {
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] <> propertyChange()");
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet]    Source    = " + event.getSource());
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet]    Property  = " + event.getPropertyName());
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet]    Old Value = " + event.getOldValue());
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet]    New Value = " + event.getNewValue());
    }

    private void processInitialRequest(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] >> processInitialRequest()");
        this.isPEDEBUG = User.getUser().hasAuth("base.rolegroup.pedebug");
        ObjectId[] moIDs = this.presentationTaskParms.getTargetIds();
        boolean hasTargets = true;
        if (this.isZHMC) {
            Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    ... using PresentationTaskParms ...");
            if (moIDs == null) {
                this.isConsoleTask = true;
                HMC hmc = HMC.getHMC();
                if (!this.schedops.containsKey(hmc)) {
                    this.schedops.put(hmc, new HashMap());
                    this.schedulables.put(hmc, new HashMap());
                }
            } else {
                this.isConsoleTask = false;
                ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
                int i = 0;
                while (i < moIDs.length) {
                    ManagedObject mo = (ManagedObject)mom.get(moIDs[i]);
                    if (mo != null && mo instanceof OperationTarget && !this.schedops.containsKey(mo)) {
                        this.schedops.put(mo, new HashMap());
                        this.schedulables.put(mo, new HashMap());
                    }
                    ++i;
                }
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    ... using Common Targeting Tasklet ...");
            CommonTargeting targeting = null;
            try {
                targeting = CommonTargeting.showTargetSelectionPanel(new SchedOpsTargetRetriever(), null, true, this);
            }
            catch (Exception e) {
                Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    Exception caught retrieving targets");
                Trace.trace(TRACE_MASKF, e);
            }
            Target[] targets = null;
            if (targeting != null && (targets = targeting.getSelectedTargets()) != null) {
                ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
                int i = 0;
                while (i < targets.length) {
                    Trace.trace(TRACE_MASKD, "[ScheduledOperationsTasklet]    Selected Name = " + targets[i].getName());
                    Trace.trace(TRACE_MASKD, "[ScheduledOperationsTasklet]    Selected ID   = " + targets[i].getObjectId());
                    Trace.trace(TRACE_MASKD, "[ScheduledOperationsTasklet]    Selected MO   = " + mom.get(targets[i].getObjectId()));
                    ManagedObject mo = (ManagedObject)mom.get(targets[i].getObjectId());
                    if (mo == null && targets[i].getObjectId().equals(HMC.getHMC().getObjectId())) {
                        mo = HMC.getHMC();
                    }
                    if (mo != null && mo instanceof OperationTarget && !this.schedops.containsKey(mo)) {
                        this.schedops.put(mo, new HashMap());
                        this.schedulables.put(mo, new HashMap());
                    }
                    ++i;
                }
            }
            boolean bl = hasTargets = targets != null;
        }
        if (hasTargets) {
            this.refreshSchedulables();
            this.refreshInventory();
            response.replace(AUIML_FILE, CUSTOMIZE_PANEL, new SchedOpsBean("SchedOpsBean", this.createDisplayDataList(), this.filter.getDisplayString()));
        } else {
            Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    No targets selected ... exiting ... ");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] << processInitialRequest()");
    }

    private void processTaskShutdown(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] >> processTaskShutdown()");
        response.terminate();
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] << processTaskShutdown()");
    }

    private void refreshInventory() throws TaskletException {
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] >> refreshInventory()");
        this.showBusyDialog(new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", BUSY_QRY_TITLE), new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", BUSY_QRY_MSG));
        this.lastRefresh = new Date();
        int nextID = 0;
        StringBuffer errors = new StringBuffer();
        Iterator itor1 = this.schedops.keySet().iterator();
        while (itor1.hasNext()) {
            OperationTarget target = (OperationTarget)itor1.next();
            List list = new ArrayList();
            try {
                list = target.getScheduler().getScheduledOperations(target);
            }
            catch (SchedulerException e) {
                Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet] Scheduled Operations could not be retrieved for " + target);
                errors.append(target.getDisplayableName().toString());
                errors.append(" ");
            }
            HashMap<Integer, ScheduledOperation> filtered = new HashMap<Integer, ScheduledOperation>();
            Iterator itor2 = list.iterator();
            while (itor2.hasNext()) {
                ScheduledOperation schedop = (ScheduledOperation)itor2.next();
                if (schedop.getSchedulable().getDescriptor().isDisplayableOnUI(schedop.getOperationTarget())) {
                    filtered.put(new Integer(++nextID), schedop);
                    continue;
                }
                Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    SchedOp filtered : " + schedop.getSchedulable());
            }
            this.schedops.put(target, filtered);
        }
        this.destroyBusyDialog();
        if (errors.length() > 0) {
            SchedOpsMessage message = new SchedOpsMessage("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", "XTIMQRYERR");
            this.popupMessageDialog(message, new String[]{errors.toString()});
        }
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] << refreshInventory()");
    }

    private void refreshSchedulables() {
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] >> refreshSchedulables()");
        int nextID = 0;
        Iterator itor1 = this.schedops.keySet().iterator();
        while (itor1.hasNext()) {
            OperationTarget target = (OperationTarget)itor1.next();
            HashMap map = new HashMap();
            Iterator itor2 = target.getSchedulables().iterator();
            while (itor2.hasNext()) {
                map.put(new Integer(++nextID), itor2.next());
            }
            this.schedulables.put(target, map);
        }
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] << refreshSchedulables()");
    }

    private ArrayList createDisplayDataList() {
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] >> createDisplayDataList()");
        Date cutoff = this.filter.getDisplayDelta(this.lastRefresh);
        Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    Last Refresh = " + this.lastRefresh);
        Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    Cutoff Date  = " + cutoff);
        Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    Criteria     = " + this.filter);
        ArrayList<DisplayDataImpl> result = new ArrayList<DisplayDataImpl>();
        Iterator itor1 = this.schedops.entrySet().iterator();
        while (itor1.hasNext()) {
            Map.Entry entry1 = itor1.next();
            OperationTarget target = (OperationTarget)entry1.getKey();
            HashMap map = (HashMap)entry1.getValue();
            Iterator itor2 = map.entrySet().iterator();
            while (itor2.hasNext()) {
                SchedulableDescriptor descriptor;
                Map.Entry entry2 = itor2.next();
                ScheduledOperation schedop = (ScheduledOperation)entry2.getValue();
                if (cutoff != null && !cutoff.after(schedop.getSchedule().getNextScheduledDate(this.lastRefresh)) || !(descriptor = schedop.getSchedulable().getDescriptor()).isDisplayableOnUI(target)) continue;
                result.add(new DisplayDataImpl((Integer)entry2.getKey(), schedop));
            }
        }
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] << createDisplayDataList() : Count = " + result.size());
        return result;
    }

    private ArrayList createDisplayDataNewList() {
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] >> createDisplayDataNewList()");
        ArrayList<DisplayDataNewImpl> result = new ArrayList<DisplayDataNewImpl>();
        Iterator itor1 = this.schedulables.keySet().iterator();
        while (itor1.hasNext()) {
            ManagedObject mo = (ManagedObject)itor1.next();
            HashMap scheds = (HashMap)this.schedulables.get(mo);
            HashMap map = new HashMap();
            Iterator itor2 = scheds.entrySet().iterator();
            while (itor2.hasNext()) {
                Map.Entry entry = itor2.next();
                SchedulableDescriptor descriptor = (SchedulableDescriptor)entry.getValue();
                if (!descriptor.isSelectableOnUI((OperationTarget)((Object)mo))) continue;
                map.put(entry.getKey(), descriptor.getDescription());
            }
            result.add(new DisplayDataNewImpl(mo.getObjectId(), ((OperationTarget)((Object)mo)).getDisplayableName(), map));
        }
        Collections.sort(result, new SortByObjectsNew());
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] << createDisplayDataNewList() : Count = " + result.size());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createScheduledOperations() throws TaskletException {
        boolean success;
        block10: {
            Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] >> createScheduledOperations()");
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(this.pending.date);
            success = true;
            try {
                try {
                    ScheduledOperation schedop = null;
                    Scheduler scheduler = this.pending.target.getScheduler();
                    if (this.pending.days.size() > 0) {
                        Delta delta = new Delta(calendar.get(7));
                        this.showBusyDialog(new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", BUSY_ADD_TITLE), new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", BUSY_ADD_MSG));
                        Iterator iterator = this.pending.days.iterator();
                        while (iterator.hasNext()) {
                            int deltaDays = delta.calcDelta((Integer)iterator.next());
                            calendar.add(5, deltaDays);
                            Schedule schedule = new Schedule(calendar.getTime(), this.pending.woo, this.pending.reps, this.pending.freq);
                            schedop = new ScheduledOperation(this.pending.target, this.pending.schedulable, schedule, this.pending.parms);
                            byte[] netid = SimServer.getSimServer().readSim(6);
                            schedop.setCreationSourceNetID(new String(netid, 0, 8));
                            schedop.setCreationSourceName(HMC.getHMC().getUIInfo().getName());
                            scheduler.addScheduledOperation(schedop);
                            calendar.setTime(this.pending.date);
                        }
                        this.destroyBusyDialog();
                    } else {
                        Schedule schedule = new Schedule(calendar.getTime(), this.pending.woo, this.pending.reps, this.pending.freq);
                        schedop = new ScheduledOperation(this.pending.target, this.pending.schedulable, schedule, this.pending.parms);
                        byte[] netid = SimServer.getSimServer().readSim(6);
                        schedop.setCreationSourceNetID(new String(netid, 0, 8));
                        schedop.setCreationSourceName(HMC.getHMC().getUIInfo().getName());
                        this.showBusyDialog(new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", BUSY_ADD_TITLE), new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", BUSY_ADD_MSG));
                        scheduler.addScheduledOperation(schedop);
                        this.destroyBusyDialog();
                    }
                    Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet] NetID = " + schedop.getCreationSourceNetID());
                    SchedOpsMessage message = this.pending.days.size() < 2 ? new SchedOpsMessage("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", MSG_B1TI3) : new SchedOpsMessage("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", MSG_B1TI4);
                    this.popupMessageDialog(message, null, OK_BUTTON);
                }
                catch (IllegalArgumentException exception) {
                    Trace.trace(TRACE_MASKF, CLASS_NAME + exception.toString());
                    success = false;
                    if (exception instanceof ScheduleException) {
                        Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet] Error = " + ((ScheduleException)exception).getError());
                        this.popupScheduleExceptionDialog((ScheduleException)exception);
                    }
                    Object var11_17 = null;
                    break block10;
                }
                catch (SchedulerException exception) {
                    Trace.trace(TRACE_MASKF, CLASS_NAME + exception.toString());
                    success = false;
                    SchedOpsMessage message = new SchedOpsMessage("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", "XTIMADDERR");
                    String target = this.pending.target.getDisplayableName().toString();
                    this.popupMessageDialog(message, new String[]{target, exception.getLocalizedMessage()});
                    Object var11_18 = null;
                    break block10;
                }
                catch (Exception exception) {
                    Trace.trace(TRACE_MASKF, CLASS_NAME + exception.toString());
                    success = false;
                    Object var11_19 = null;
                }
                Object var11_16 = null;
            }
            catch (Throwable throwable) {
                Object var11_20 = null;
                throw throwable;
            }
        }
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] << createScheduledOperations()");
        return success;
    }

    private String removeScheduledOperations(ArrayList list) {
        String result = null;
        HashMap errors = new HashMap();
        try {
            this.showBusyDialog(new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", BUSY_CAN_TITLE), new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", BUSY_CAN_MSG));
        }
        catch (TaskletException e) {
            // empty catch block
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Integer uniqueID = (Integer)iterator.next();
            ScheduledOperation schedop = this.findScheduledOperation(uniqueID);
            if (schedop == null) continue;
            boolean success = true;
            try {
                schedop.getOperationTarget().getScheduler().removeScheduledOperation(schedop);
            }
            catch (SchedulerException e) {
                success = false;
                String name = schedop.getOperationTarget().getDisplayableName().toString();
                errors.put(name, null);
            }
            if (!success) continue;
            this.removeScheduledOperation(uniqueID);
        }
        try {
            this.destroyBusyDialog();
        }
        catch (TaskletException e) {
            // empty catch block
        }
        if (!errors.isEmpty()) {
            StringBuffer buffer = new StringBuffer();
            Iterator iterator2 = errors.keySet().iterator();
            while (iterator2.hasNext()) {
                buffer.append((String)iterator2.next());
                buffer.append(" ");
            }
            result = buffer.toString();
        }
        return result;
    }

    private void removeScheduledOperation(Integer uniqueID) {
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] <> removeScheduledOperation()");
        boolean found = false;
        Iterator itor1 = this.schedops.keySet().iterator();
        while (itor1.hasNext()) {
            HashMap map = (HashMap)this.schedops.get(itor1.next());
            Iterator itor2 = map.keySet().iterator();
            while (itor2.hasNext()) {
                Integer key = (Integer)itor2.next();
                if (!uniqueID.equals(key)) continue;
                itor2.remove();
                found = true;
                break;
            }
            if (found) break;
        }
    }

    private ScheduledOperation findScheduledOperation(Integer uniqueID) {
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] >> findScheduledOperation() : ID = " + uniqueID);
        ScheduledOperation result = null;
        Iterator itor1 = this.schedops.keySet().iterator();
        while (itor1.hasNext()) {
            HashMap map = (HashMap)this.schedops.get(itor1.next());
            Iterator itor2 = map.keySet().iterator();
            while (itor2.hasNext()) {
                Integer key = (Integer)itor2.next();
                if (!uniqueID.equals(key)) continue;
                result = (ScheduledOperation)map.get(key);
                break;
            }
            if (result != null) break;
        }
        Trace.trace(TRACE_MASKT, "[ScheduledOperationsTasklet] << findScheduledOperation() : SchedOp = " + result);
        return result;
    }

    private void displayAddSchedOp(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        response.openModalChild(AUIML_FILE, ADD_SCHEDOP_PANEL, new AddSchedOpsBean("AddSchedOpsBean", this.createDisplayDataNewList(), this.isConsoleTask));
    }

    private void displayDateTimeRepeat(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        SetUpSchedOpsBean setupBean = new SetUpSchedOpsBean("SetUpSchedOpsBean");
        DisplayAreaDescriptorData tabbedPane = new DisplayAreaDescriptorData(AUIML_FILE, SETUP_SCHEDOP_PANEL, setupBean, null, null);
        ArrayList<LocalizableText> objectNames = new ArrayList<LocalizableText>();
        objectNames.add(this.pending.target.getDisplayableName());
        DateTimeBean dtBean = new DateTimeBean("DateTimeBean", objectNames);
        DisplayAreaDescriptorData dateTimeTab = new DisplayAreaDescriptorData(AUIML_FILE, DATE_TIME_PANEL, dtBean, null, null, SETUP_SCHEDOP_MOUNT);
        RepeatBean rBean = new RepeatBean("RepeatBean", objectNames, this.isPEDEBUG);
        DisplayAreaDescriptorData repeatTab = new DisplayAreaDescriptorData(AUIML_FILE, REPEAT_PANEL, rBean, null, null, SETUP_SCHEDOP_MOUNT);
        String parmsTasklet = this.pending.schedulable.getDescriptor().getOperationParametersTasklet();
        if (parmsTasklet != null) {
            this.initData = new OperationParametersTasklet.InitData(OperationParametersTasklet.RequestType.CREATE, this.pending.target, null);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("REQUEST", "REQUEST_CREATE");
            map.put("TARGET", this.pending.target);
            map.put("PARAMETERS", null);
            this.addPropertyChangeListener("SubtaskletChildrenProperty", this);
            DisplayAreaDescriptorDelegate parmsTab = new DisplayAreaDescriptorDelegate(parmsTasklet, map);
            parmsTab.setMountPoint(SETUP_SCHEDOP_MOUNT);
            response.replace(tabbedPane, new DisplayAreaDescriptor[]{dateTimeTab, repeatTab, parmsTab});
        } else {
            response.replace(tabbedPane, new DisplayAreaDescriptor[]{dateTimeTab, repeatTab});
        }
    }

    private void displayDetails(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        ArrayList list = (ArrayList)request.getData("DATA");
        ScheduledOperation schedop = this.findScheduledOperation((Integer)list.get(0));
        if (!schedop.getSchedule().isExpired()) {
            Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]    Showing details ... ");
            Schedulable schedulable = schedop.getSchedulable();
            String parmsTasklet = schedulable.getDescriptor().getOperationParametersTasklet();
            SchedOpsDetailsBean detailsBean = new SchedOpsDetailsBean("SchedOpsDetailsBean", new DisplayDataImpl((Integer)list.get(0), schedop));
            if (parmsTasklet == null) {
                response.openModalChild(AUIML_FILE, DETAILS_PANEL, detailsBean);
            } else {
                this.initData = new OperationParametersTasklet.InitData(OperationParametersTasklet.RequestType.DISPLAY, schedop.getOperationTarget(), schedop.getOperationParameters());
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("REQUEST", "REQUEST_DISPLAY");
                map.put("TARGET", schedop.getOperationTarget());
                map.put("PARAMETERS", schedop.getOperationParameters());
                DetailsFrameBean frameBean = new DetailsFrameBean("DetailsFrameBean");
                DisplayAreaDescriptorData tabbedPane = new DisplayAreaDescriptorData(AUIML_FILE, DETAILS_FRAME_PANEL, frameBean, null, null);
                DisplayAreaDescriptorData detailsTab = new DisplayAreaDescriptorData(AUIML_FILE, DETAILS_TAB_PANEL, detailsBean, null, null, DETAILS_SCHEDOP_MOUNT);
                DisplayAreaDescriptorDelegate parmsTab = new DisplayAreaDescriptorDelegate(parmsTasklet, map);
                parmsTab.setMountPoint(DETAILS_SCHEDOP_MOUNT);
                response.openModalChild(tabbedPane, new DisplayAreaDescriptor[]{detailsTab, parmsTab});
            }
        } else {
            Trace.trace(TRACE_MASKF, "[ScheduledOperationsTasklet]   Operation expired ... cannot show details ... ");
            SchedOpsMessage message = new SchedOpsMessage("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", "XTIMDETERR");
            this.popupMessageDialog(message);
            response.noAction();
        }
    }

    private void displayNewTimeRange(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        String selected = null;
        if (this.filter.getRange() == DisplayFilter.Types.ALL) {
            selected = "AllItem";
        } else if (this.filter.getRange() == DisplayFilter.Types.DAYS) {
            selected = "DaysItem";
        } else if (this.filter.getRange() == DisplayFilter.Types.WEEKS) {
            selected = "WeeksItem";
        } else if (this.filter.getRange() == DisplayFilter.Types.MONTHS) {
            selected = "MonthsItem";
        }
        response.openModalChild(AUIML_FILE, TIME_RANGE_PANEL, new TimeRangeBean("TimeRangeBean", this.filter.getAmount(), selected, this.filter.getDisplayString()));
    }

    private LocalizableText popupScheduleExceptionDialog(ScheduleException exception) throws TaskletException {
        SchedOpsMessage message = null;
        message = exception.getError() == ScheduleException.Error.EXPIRED ? new SchedOpsMessage("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", MSG_B1TN1) : (exception.getError() == ScheduleException.Error.FREQUENCY ? new SchedOpsMessage("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", MSG_B1TN2) : (exception.getError() == ScheduleException.Error.REPETITIONS ? new SchedOpsMessage("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", MSG_B1TN3) : (exception.getError() == ScheduleException.Error.WIND_FREQ ? new SchedOpsMessage("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", MSG_B1TN5) : new SchedOpsMessage("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", MSG_UNKWN))));
        return this.showMessageBox(true, message.getTitle(), new MessageText[]{message.getText()}, message.getNumber(), message.getType(), OK_BUTTON);
    }

    private LocalizableText popupMessageDialog(SchedOpsMessage message) throws TaskletException {
        return this.popupMessageDialog(message, null);
    }

    private LocalizableText popupMessageDialog(SchedOpsMessage message, String[] substitution) throws TaskletException {
        return this.popupMessageDialog(message, substitution, OK_CANCEL_BUTTONS);
    }

    private LocalizableText popupMessageDialog(SchedOpsMessage message, String[] substitution, LocalizableText[] buttons) throws TaskletException {
        return this.showMessageBox(true, message.getTitle(), new MessageText[]{message.getText(substitution)}, message.getNumber(), message.getType(), buttons);
    }

    private static class SortByName
    implements Comparator {
        private SortByName() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = ((Target)o1).getName().toString();
            String s2 = ((Target)o2).getName().toString();
            return s1.compareTo(s2);
        }
    }

    private static class SchedOpsTargetRetriever
    implements TargetRetriever {
        private static final String CLASS_NAME = "[SchedOpsTargetRetriever] ";
        private static final String TITLE = "XTIM.TITLE";
        private static final String SELECT = "XTIM.SELECT_TARGETS";

        private SchedOpsTargetRetriever() {
        }

        public Target[] getTargets(String taskid, Target[] target) {
            Trace.trace(ScheduledOperationsTasklet.TRACE_MASKT, "[SchedOpsTargetRetriever] >> getTargets()");
            ManagedObjectManager mom = ManagedObjectManager.getManagedObjectManager();
            Collection classes = SchedulableConfigManager.getSchedulableTargets();
            ArrayList<HMC> mos = new ArrayList<HMC>();
            String hmcClass = HMC.getHMC().getClass().getName();
            Iterator iterator = classes.iterator();
            while (iterator.hasNext()) {
                String className = (String)iterator.next();
                Trace.trace(ScheduledOperationsTasklet.TRACE_MASKF, "[SchedOpsTargetRetriever]    Class Name = " + className);
                if (className.equals(hmcClass)) {
                    mos.add(HMC.getHMC());
                    continue;
                }
                ClassId classID = null;
                try {
                    classID = new ClassId(Class.forName(className));
                }
                catch (Exception e) {
                    Trace.trace(ScheduledOperationsTasklet.TRACE_MASKD, e);
                }
                Trace.trace(ScheduledOperationsTasklet.TRACE_MASKF, "[SchedOpsTargetRetriever]    Class ID   = " + classID);
                if (classID == null) continue;
                mos.addAll(mom.getInventory(classID));
            }
            Target[] targets = new Target[mos.size()];
            Trace.trace(ScheduledOperationsTasklet.TRACE_MASKF, "[SchedOpsTargetRetriever]    Found " + targets.length + " targets ... ");
            int i = 0;
            while (i < targets.length) {
                ManagedObject mo = (ManagedObject)mos.get(i);
                Trace.trace(ScheduledOperationsTasklet.TRACE_MASKF, "[SchedOpsTargetRetriever]    Target Name  = " + ((OperationTarget)((Object)mo)).getDisplayableName());
                Trace.trace(ScheduledOperationsTasklet.TRACE_MASKF, "[SchedOpsTargetRetriever]    Target Class = " + mo.getClass());
                Trace.trace(ScheduledOperationsTasklet.TRACE_MASKF, "[SchedOpsTargetRetriever]    Target ID    = " + mo.getObjectId());
                targets[i] = new Target(mo.getObjectId(), ((OperationTarget)((Object)mo)).getDisplayableName());
                ++i;
            }
            Arrays.sort(targets, new SortByName());
            Trace.trace(ScheduledOperationsTasklet.TRACE_MASKT, "[SchedOpsTargetRetriever] << getTargets()");
            return targets;
        }

        public TargetActionListener[] getActions(String taskid) {
            return null;
        }

        public LocalizableText getPanelTitle(String taskid) {
            return new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", TITLE);
        }

        public LocalizableText getPanelText(String taskid) {
            return new LocalizableText("com.ibm.hwmca.fw.schedops.res.SchedOpsMsgs", SELECT);
        }

        public String getPanelHelpInfo(String taskid) {
            return null;
        }

        public LocalizableText[] getColumnHeaders(String taskid) {
            return null;
        }
    }

    private static class SortByObjectsNew
    implements Comparator {
        private SortByObjectsNew() {
        }

        public int compare(Object o1, Object o2) {
            String s1 = ((DisplayDataNewImpl)o1).getObjectName().toString();
            String s2 = ((DisplayDataNewImpl)o2).getObjectName().toString();
            return s1.compareTo(s2);
        }
    }

    private static class Delta {
        private static final int MAX = 7;
        private int delta;

        public Delta(int base) {
            this.delta = 7 - base;
        }

        public int calcDelta(int current) {
            return (current + this.delta) % 7;
        }
    }

    private static class SchedOpPending {
        private boolean complete = true;
        public OperationTarget target = null;
        public Schedulable schedulable = null;
        public Object parms = null;
        public Date date = null;
        public ArrayList days = null;
        public Long woo = null;
        public Long reps = null;
        public Long freq = null;

        private SchedOpPending() {
        }

        public synchronized void setComplete(boolean flag) {
            this.complete = flag;
        }

        public synchronized boolean isComplete() {
            return this.complete;
        }
    }
}

